#!/usr/bin/perl

# Set these for your situation
my $EMPIREDIR = "/home/mednafenuser/mednafen-server";
my $BACKUPDIR = "/home/mednafenuser/backups";
my $TARCMD = "/bin/tar czf";
my $VERSION = "1.0.0";

# Init file data
my $MySettings = "$ENV{'HOME'}/.mbackuprc";
my $BACKUPUSER = "";
my $BACKUPPASS = "";
my $BACKUPSERVER = "";
my $BACKUPPATH = "";
my $DEBUG_MODE = "off";

#-------------------
# No changes below here...
#-------------------

sub ReadConfigFile
{
	# Check for config file
	if (-f $MySettings)
	{
		# Read in settings
		open (my $FH, "<", $MySettings) or die "Could not read default file '$MySettings' $!";
		while (<$FH>)
		{
			chop();
			my ($Command, $Setting) = split(/=/, $_);
			if ($Command eq "backupuser")
			{
				$BACKUPUSER = $Setting;
			}
			if ($Command eq "backuppass")
			{
				$BACKUPPASS = $Setting;
			}
			if ($Command eq "backupserver")
			{
				$BACKUPSERVER = $Setting;
			}
			if ($Command eq "backuppath")
			{
				$BACKUPPATH = $Setting;
			}
			if ($Command eq "debugmode")
			{
				$DEBUG_MODE = $Setting;
			}
		}
		close($FH);
	}
	else
	{
		# Store defaults
		open (my $FH, ">", $MySettings) or die "Could not create default file '$MySettings' $!";
		print $FH "backupuser=\n";
		print $FH "backuppass=\n";
		print $FH "backupserver=\n";
		print $FH "backuppath=\n";
		print $FH "debugmode=off\n";
		close($FH);
	}
}

sub PrintDebugCommand
{
	if ($DEBUG_MODE eq "off")
	{
		return;
	}
	my $PassedString = shift;
	print "About to run:\n$PassedString\n";
	print "Press Enter To Run This:";
	my $entered = <STDIN>;
}

ReadConfigFile();

print "MednafenBackup - back up your Mednafen server - version $VERSION\n";
print "=================================================================\n";

if (! -d $BACKUPDIR)
{
	print "Backup dir $BACKUPDIR not found, creating...\n";
	system("mkdir -p $BACKUPDIR");
}
print "Moving existing backups: ";

if (-f "$BACKUPDIR/mednafenbackup-5.tgz")
{
	unlink("$BACKUPDIR/mednafenebackup-5.tgz")  or warn "Could not unlink $BACKUPDIR/mednafenebackup-5.tgz: $!";
}
if (-f "$BACKUPDIR/mednafenebackup-4.tgz")
{
	rename("$BACKUPDIR/mednafenebackup-4.tgz", "$BACKUPDIR/mednafenebackup-5.tgz");
}
if (-f "$BACKUPDIR/mednafenebackup-3.tgz")
{
	rename("$BACKUPDIR/mednafenebackup-3.tgz", "$BACKUPDIR/mednafenebackup-4.tgz");
}
if (-f "$BACKUPDIR/mednafenebackup-2.tgz")
{
	rename("$BACKUPDIR/mednafenebackup-2.tgz", "$BACKUPDIR/mednafenebackup-3.tgz");
}
if (-f "$BACKUPDIR/mednafenebackup-1.tgz")
{
	rename("$BACKUPDIR/mednafenebackup-1.tgz", "$BACKUPDIR/mednafenebackup-2.tgz");
}
print "Done\nCreating Backup: ";
system("$TARCMD $BACKUPDIR/mednafenebackup-1.tgz $EMPIREDIR");
if ($BACKUPSERVER ne "")
{
	print "Offsite backup requested\n";
	print "Copying $BACKUPDIR/mednafenebackup-1.tgz to $BACKUPSERVER:$BACKUPPORT\n";
	PrintDebugCommand("rsync -avz -e ssh $BACKUPDIR/mednafenebackup-1.tgz $BACKUPUSER\@$BACKUPSERVER:$BACKUPPATH\n");
	system ("rsync -avz -e ssh $BACKUPDIR/mednafenebackup-1.tgz $BACKUPUSER\@$BACKUPSERVER:$BACKUPPATH");
}

print("Done!\n");
exit 0;
